// Copyright 2025 Greyscalegorilla, Inc. 

#pragma once

#include "CoreMinimal.h"
#include "GreyscalegorillaMessages.generated.h"

UENUM(BlueprintType)
enum class GSGConnectErrorCode : uint8
{
    InvalidMetadata UMETA(DisplayName = "Invalid Metadata"),
    ModelsNotFound UMETA(DisplayName = "Models Not Found"),
    ModelsNotLoaded UMETA(DisplayName = "Models Not Loaded"),
    MaterialsNotFound UMETA(DisplayName = "Materials Not Found"),
    MaterialsNotLoaded UMETA(DisplayName = "Materials Not Loaded"),
};

USTRUCT(BlueprintType)
struct FGSGConnectError
{
    GENERATED_BODY()

    UPROPERTY(VisibleAnywhere, BlueprintReadWrite, Category = "Error")
    GSGConnectErrorCode ErrorCode;

    UPROPERTY(VisibleAnywhere, BlueprintReadWrite, Category = "Error")
    FString Message;

    UPROPERTY(VisibleAnywhere, BlueprintReadWrite, Category = "Error")
    FString PathToAsset;

    FGSGConnectError()
        : ErrorCode(GSGConnectErrorCode::InvalidMetadata), Message(TEXT("")), PathToAsset(TEXT(""))
    {
    }

    FGSGConnectError(GSGConnectErrorCode InErrorCode, const FString &InMessage, const FString &InPathToAsset)
        : ErrorCode(InErrorCode), Message(InMessage), PathToAsset(InPathToAsset)
    {
    }
};

USTRUCT(BlueprintType)
struct FGSGConnectSuccess
{
    GENERATED_BODY()

    UPROPERTY(VisibleAnywhere, BlueprintReadWrite, Category = "Error")
    FString PathToAsset;

    FGSGConnectSuccess()
        : PathToAsset(TEXT(""))
    {
    }

    FGSGConnectSuccess(const FString &InPathToAsset)
        : PathToAsset(InPathToAsset)
    {
    }
};